//+------------------------------------------------------------------+
//|                                Profit Generator - Daily Bars.mq4 |
//|                       No Copyright, created in 2006, Open Source |
//|                                         http://www.forex-tsd.com |
//|                                       http://www.tradingintl.com | 
//|        Freely receive, Freely give. Please post updated version. |
//+------------------------------------------------------------------+

#property copyright "Created in 2006, Open Source Project"
#property link      "http://www.forex-tsd.com"
#include <stdlib.mqh>
#include <WinUser32.mqh>


///////////////////////////////////////////////////Variables//////////////////////////////

extern int     ID; // Change this number if running more than one EA on the same pair
extern double  lots=1.0; // This number will not matter if using Money Management 
extern bool    MM = false; //Use Money Management or not
extern double  Risk = 10; //percent of available margin to risk.

extern int  stoploss=30,takeprofit=40;

extern bool UseClose=false; // This will use the SuperClose().  
extern int  TSactivation=40,TrailPips=5; // TSactivation will set the point where the TS will start. 
extern int  LongBar=10; // sets the minimum length of the bar

extern int  MaxTrades=1;          //maximum number of trades open at a time
extern bool UseHourTrade = true; // Time filter
extern int  FromHourTrade = 7; // start trading on this hour
extern int  ToHourTrade = 20; // end trading on this hour
extern bool UseLastPeriodPerams=false;// uses the high and low from last period for calculation
extern int  period=0; // leave this number as zero to use the period from the chart.
extern bool OneTradeperPeriod=false;  //This will only allow one new trade per period.
extern bool Alerts=false,AlertOnlyMode=false;// Alerts will alert when trade signal is present.  AOM will not place trades, but will alert to the platform
extern bool  WeekendMode=false;//True=Will close all trades on and after the hour to close.
extern int  hour_to_close=21;

int bar;//tracks the period where a trade was placed. 

int     tsTicket[21];
double  tsPrice[21];
bool    tsok[21];
//bool hedged;
//////////////////////////////////////////////////////////////////////////////////////////////
int start(){

   if((DayOfWeek()>=5) && (Hour()>=hour_to_close)){
      if(WeekendMode){  
         if(orderscnt()>0){
            CloseAllTrades();
         }
    //  Print("Day = ",DayOfWeek()," Hour = ",Hour());
         return(0);
      } 
   }   
   if(UseClose)SuperClose();
   if (UseHourTrade){
      if(!(Hour()>=FromHourTrade&&Hour()<=ToHourTrade)){
       //  Comment("Non-Trading Hours!");
         return(0);
      }
   }
   if(orderscnt()<MaxTrades){
      if(MM==true) lots = LotSize();
      CheckOpen();
   }
}
//////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////   
       
void CheckOpen(){ 
 
   double tp,sl;
   double Hi, Lo, Op;
   bool y=OneTradeperPeriod; //added 3-25-2006
   string comm="Pro-Gen_"+DoubleToStr(ID,0);
   if(UseLastPeriodPerams)int x=1; else x=0;
   
   Hi = iHigh(NULL, P(), x); 
   Lo = iLow( NULL, P(), x);  
   Op = iOpen(NULL, P(), x);
  
//   Print(Hi, ",", Lo); // This shows how the value of hi and lo changes during the day
//   Comment("if (",(Hi-Lo)," > ",LongBar*Point," && ",Op," < ",Hi+Lo/2," && ",Ask," < ",Op);

//   if ((High[0]-Low[0])>LongBar*Point && Open[0]<(High[0]+Low[0])/2 && Ask < Open[0])
   if((Hi-Lo)>LongBar*Point && Op<(Hi+Lo)/2 && Ask < Op && ( bar!=Bars || !y) ){
      if(stoploss==0){sl=0;}else{sl=Ask-stoploss*Point;}
      if(takeprofit==0 || UseClose){tp=0;}else{tp=Ask+takeprofit*Point;}
      if(!AlertOnlyMode){
         OrderSend(Symbol(),OP_BUY,lots,Ask,2,sl,tp,comm,ID,0,Blue);
         bar=iBars(NULL,P());
      }
      if(Alerts || AlertOnlyMode){
          Alert("PG Long Signal on ",Symbol());
      } 
   }
//   if ((High[0]-Low[0])>LongBar*Point && Open[0]>(High[0]+Low[0])/2 && Bid > Open[0])
   if((Hi-Lo)>LongBar*Point && Op>(Hi+Lo)/2 && Bid > Op && (bar!=Bars || !y) ){
      if(stoploss==0){sl=0;}else{sl=Bid+stoploss*Point;}
      if(takeprofit==0 || UseClose){tp=0;}else{tp=Bid-takeprofit*Point;}
      if(!AlertOnlyMode){
         OrderSend(Symbol(),OP_SELL,lots,Bid,2,sl,tp,comm,ID,0,Red); 
         bar=iBars(NULL,P());
      }
      if(Alerts || AlertOnlyMode){
            Alert("PG Short Signal on ",Symbol()); 
      }
   }
}
//////////////////////////////////////////////////////////////////////////////////////////////
int P(){
   if(period==0){
      return(Period()); 
   }else{
      return(period);
   }
}
//////////////////////////////////////////////////////////////////////////////////////////////
int orderscnt(){
int cnt=0;
   for(int i =0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
         if(OrderSymbol()==Symbol() && ID==OrderMagicNumber()){
            cnt++;
         }
      }
   }
   return(cnt);
}
//////////////////////////////////////////////////////////////////////////////////////////////
void CloseAllTrades(){
Print("CloseAllTrades()");
   for(int i =0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
         if(OrderSymbol()==Symbol() && ID==OrderMagicNumber()){
            if(OrderType()==OP_BUY){
               CloseOrder(1);
            }else{
               CloseOrder(2);
            }  
         }  
      }  
   }  
}  
////////////////////////////////////////////////////////////////////////////////////////////// 
double LotSize(){
   double lotMM = MathCeil(AccountFreeMargin() * Risk / 10000) / 10;
   if (lotMM < 0.1) lotMM = lots;
   if (lotMM > 1.0) lotMM = MathCeil(lotMM);
   if  (lotMM > 100) lotMM = 100;
   return (lotMM);
} 

//////////////////////////////////////////////////////////////////////////////////////////////
void SuperClose(){
   for(int i=0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS)){
         if(OrderSymbol()==Symbol() && OrderMagicNumber()==ID){
            int num=0;int pos=0;
            for(int b=0;b<21;b++){
               if(tsTicket[b]==OrderTicket() ){
                  num++; pos=b;
                  Print("(",pos,") Ticket ",tsTicket[pos]," found.  SL is ",tsPrice[pos]);
                  break;
               }  
            }
            if(num==0){
               for(int j=0;j<21;j++){
                  if(tsTicket[j]==0){
                     pos=j;
                     
                     break;
                  }
               }
               tsTicket[pos]=OrderTicket();
               tsok[pos]=false;
               Print("(",pos,") New ticket initialized = ",tsTicket[pos]);
            }
            if (OrderType()==OP_SELL) {
               if (!tsok[pos] && (OrderOpenPrice()-Ask>=TSactivation*Point || TSactivation==0 ) ) {
                  tsPrice[pos]=Ask+TrailPips*Point;
                  tsok[pos]=true;
                  if(TrailPips>8){
                     ModifyStopLoss(Ask+TrailPips*Point);
                  }
               }
               if (tsok[pos] && Ask+TrailPips*Point < tsPrice[pos] ){
                  tsPrice[pos]=Ask+TrailPips*Point;
                  if(TrailPips>8){ 
                     ModifyStopLoss(Ask+TrailPips*Point);
                  }
               }
               if (tsok[pos] && Ask >= tsPrice[pos] ){
                  CloseOrder(2);
                  Print("Order ",tsTicket[pos]," Closed from TS");
               }
            }
            if (OrderType()==OP_BUY) {
               if(!tsok[pos] && (Bid-OrderOpenPrice() >= TSactivation*Point  || TSactivation==0 ) ) {
                  tsPrice[pos]=Bid-TrailPips*Point;
                  tsok[pos]=true;
                  if(TrailPips>8){
                     ModifyStopLoss(Bid-TrailPips*Point);
                  }
               }
               if (tsok[pos] && Bid-TrailPips*Point > tsPrice[pos] ){
                  tsPrice[pos]=Bid-TrailPips*Point;
                  if(TrailPips > 8){
                     ModifyStopLoss(Bid-TrailPips*Point);
                  }
               }
               if (tsok[pos] && Bid <= tsPrice[pos] ){
                  CloseOrder(1);
                  Print("Order ",tsTicket[pos]," Closed from TS");
   }  }  }  }  }
   for(i=0;i<21;i++){
      if(tsTicket[i]>0){
         bool found=false;
         for(b=0;b<OrdersTotal();b++){
            OrderSelect(b,SELECT_BY_POS);
            if(tsTicket[i]==OrderTicket()){
               found=true;
             break;
            }
         }
         if(!found){
            tsTicket[i]=0;tsPrice[i]=0;tsok[i]=false;
            Print("Array pos ",i," Cleaned");
}  }  }  }
//////////////////////////////////////////////////////////////////////////////////////////////           

void CloseOrder(int ord){
   if (ord==1){
      int res = OrderClose(OrderTicket(),OrderLots(),Bid,3,White); // close 
      if(res<0){
         int error=GetLastError();
         Print("Error = ",ErrorDescription(error));
      }
   }
   if (ord==2) {                          // MA BUY signals
      res = OrderClose(OrderTicket(),OrderLots(),Ask,3,White); // close 
      if(res<0){
         error=GetLastError();
         Print("Error = ",ErrorDescription(error));
             
      }  
   }    
}  
//////////////////////////////////////////////////////////////////////////////////////////////
void ModifyStopLoss(double ldStop) {
  bool   fm;
  double ldOpen=OrderOpenPrice();
  double ldTake=OrderTakeProfit();
  fm=OrderModify(OrderTicket(), ldOpen, ldStop, ldTake, 0, Pink);
}
//////////////////////////////////////////////////////////////////////////////////////////////
/*void ModifyOrder(double ldStop,double tp) {
  bool   fm;
  double ldOpen=OrderOpenPrice();
  double ldTake=tp;
  fm=OrderModify(OrderTicket(), ldOpen, ldStop, ldTake, 0, Pink);
}

void unhedge(){
int hcnt;
   for(int i =0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
         if(OrderSymbol()==Symbol() && ID==OrderMagicNumber()){
            if(OrderComment()=="hedge"){
               hcnt++;
               if(OrderType()==OP_BUY){
                  CloseOrder(1);
               }
               if(OrderType()==OP_SELL){
                  CloseOrder(2);
               }
            }
         }
      }
   }
   if(hcnt==0)hedged=false;
} 
void HedgePos(){
double b,s;
   for(int i =0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
         if(OrderSymbol()==Symbol() && ID==OrderMagicNumber()){
            if(OrderType()==OP_BUY){
               b+=OrderLots();
            }
            if(OrderType()==OP_SELL){
               s+=OrderLots();
            }
         }
      }
   }
   if(s==b){
      hedged=true;
      for(i =0;i<OrdersTotal();i++){
         if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
            if(OrderSymbol()==Symbol() && ID==OrderMagicNumber()){
               if(OrderType()==OP_BUY){
                  if(OrderStopLoss()>0){
                     osl[i]=Bid-OrderStopLoss();
                     otp[i]=Bid+OrderTakeProfit();
                     ModifyOrder(0,0);
                  }
               }
               if(OrderType()==OP_SELL){
                  if(OrderStopLoss()>0){
                     osl[i]=Ask+OrderStopLoss();
                     otp[i]=Ask-OrderTakeProfit();
                     ModifyOrder(0,0);
                  }
               }
            }
         }
      }
   }
   else if(s>b){
      double lotz=s-b;
      OrderSend(Symbol(),OP_BUY,lotz,Ask,2,0,0,"hedge",ID,0,Red);
   }
   else if(s<b){
      lotz=b-s;
      OrderSend(Symbol(),OP_SELL,lotz,Bid,2,0,0,"hedge",ID,0,Blue);
   }
}*/    